Rem
Rem $Header: regxdemo.sql 11-jan-2005.15:49:18 jmuller Exp $
Rem
Rem regxdemo.sql
Rem
Rem Copyright (c) 2003, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      regxdemo.sql - Demo program for PL/SQL REGEXP functions.
Rem
Rem    DESCRIPTION
Rem      This is a sample program to demonstrate the usage of the PL/SQL
Rem      REGEXP functions to extract email addresses from an email document.
Rem
Rem    NOTES ON EXECUTING THIS DEMO PROGRAM
Rem
Rem      Use SQL*Plus to run this demo.  Connect as SCOTT/TIGER.  Then
Rem      execute this demo program.  SQL*Plus will prompt you to enter the
Rem      values of the following variables:
Rem
Rem      a. SYSTEM password - for the purpose of creating a test directory
Rem         object
Rem      b. a test directory - this directory path must exist and must
Rem         contain regxdemo.dat email data file.
Rem
Rem    To execute this demo program:
Rem
Rem      $ sqlplus scott/tiger @regxdemo '<system pwd>' '<test dir>'
Rem
Rem    For example:
Rem
Rem    $ sqlplus scott/tiger @regxdemo 'manager' $PWD
Rem   
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jmuller     01/11/05 - Fix bug 4094454: don't hardcode character set 
Rem    sylin       09/19/03 - sylin_regexp_demo 
Rem    sylin       09/16/03 - Created
Rem

Rem SET ESCAPE \
SET SERVEROUTPUT ON SIZE 1000000

DEFINE System_Password='&&1'
DEFINE Test_Directory='&&2'

Rem Create test directory
CONNECT system/&&System_Password
CREATE OR REPLACE DIRECTORY testdir AS '&&Test_Directory';
GRANT READ ON DIRECTORY testdir TO scott;

Rem Connect as SCOTT
CONNECT scott/tiger
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
srcstr clob;
pos number := 1;
mcount binary_integer;

TYPE email_type is table of binary_integer index by varchar2(32767);
emaillist email_type;
emailid varchar2(32767);
efile     bfile := bfilename('TESTDIR','regxdemo.dat') ;
amt     integer;
srcoff  integer:= 1;
dstoff  integer := 1;
charset varchar2(100);
cs_id   number ;
lang    integer := 0;
warn    integer;
which   varchar2(32767);
begin

  /* [4094454] Read current character set from database. */
  select value into charset from nls_database_parameters
  where parameter = 'NLS_CHARACTERSET';

  dbms_lob.createtemporary(srcstr, TRUE);
  dbms_lob.fileopen(efile, dbms_lob.file_readonly);

  amt := dbms_lob.getlength(efile) ;
  cs_id := nls_charset_id(charset) ;
  dbms_lob.loadclobfromfile(srcstr,efile,amt,dstoff,srcoff,cs_id,lang,warn) ;
  commit ;
  dbms_lob.filecloseall() ;

  loop
    /* Search for the next email address */
    emailid :=
      regexp_substr(srcstr, '([[:alnum:]_.]+@[[:alnum:]_.]+)', pos, 1);
    if emailid IS NULL then
      exit;
    end if ;

    /* Get to the tail of the srcstr where the search could continue */
    pos :=
     regexp_instr(srcstr, '([[:alnum:]_.]+@[[:alnum:]_.]+)', pos,1, 1);
    if pos != 0 AND pos IS NOT NULL then
      if (emaillist.exists(emailid)) then
        mcount := emaillist(emailid);
        emaillist(emailid) := mcount + 1;
      else
        emaillist(emailid) := 1;
      end if;
    else
      exit;
    end if;
  end loop;

  dbms_output.put_line('Number of email addresses found: ' ||
                        emaillist.count);

  which := emaillist.FIRST;
  while which IS NOT NULL LOOP
    dbms_output.put_line(which);
    which := emaillist.NEXT(which);
  end loop;

end;
/
